<?php

// #################### vB Optimise Integration #########################
if ($vbulletin->options['eggavatar_optimise'])
{
    require_once(DIR . '/includes/class_activecache.php');
    $vboptimise = vb_activecache::get_instance($vbulletin->options['_vboptimise_method']);
}

// get the five most egged users
$mostegged_array = array();
if ($vbulletin->options['eggavatar_optimise'])
{
    $me_cache = $vboptimise->fetch('mostegged');

    if ($me_cache) 
    { 
        $mostegged_array = unserialize($me_cache);
        devdebug('[tk] Egg Avatar: Fetched most egged from cache.');
    }
    else
    {
        $mostegged = $vbulletin->db->query_read("
            SELECT user.userid, user.username, count(eggavatar.userid) as egged 
            FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
            LEFT JOIN " . TABLE_PREFIX . "user as user ON user.userid = eggavatar.userid 
            GROUP BY eggavatar.userid 
            ORDER BY egged DESC LIMIT 10
        ");            
    }
}
else
{
    $mostegged = $vbulletin->db->query_read("
        SELECT user.userid, user.username, count(eggavatar.userid) as egged 
        FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
        LEFT JOIN " . TABLE_PREFIX . "user as user ON user.userid = eggavatar.userid 
        GROUP BY eggavatar.userid 
        ORDER BY egged DESC LIMIT 10
    ");
}

if (empty($mostegged_array))
{
    while($me = $vbulletin->db->fetch_array($mostegged))
    {
        $mostegged_array[] = $me;
    }
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $vboptimise->set('mostegged', serialize($mostegged_array));
        devdebug('[tk] Egg Avatar: Cached most egged.');
    }
}

// get the five users who have thrown the most eggs
$mostthrown_array = array();
if ($vbulletin->options['eggavatar_optimise'])
{
    $mt_cache = $vboptimise->fetch('mostthrown');

    if ($me_cache) 
    { 
        $mostthrown_array = unserialize($mt_cache);
        devdebug('[tk] Egg Avatar: Fetched most thrown from cache.');
    }
    else
    {
        $mostthrown = $vbulletin->db->query_read("
            SELECT user.userid, user.username, count(eggavatar.eggedbyid) as thrown 
            FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
            LEFT JOIN " . TABLE_PREFIX . "user as user ON user.userid = eggavatar.eggedbyid 
            GROUP BY eggavatar.eggedbyid 
            ORDER BY thrown DESC LIMIT 10
        ");
    }
}
else
{
    $mostthrown = $vbulletin->db->query_read("
        SELECT user.userid, user.username, count(eggavatar.eggedbyid) as thrown 
        FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
        LEFT JOIN " . TABLE_PREFIX . "user as user ON user.userid = eggavatar.eggedbyid 
        GROUP BY eggavatar.eggedbyid 
        ORDER BY thrown DESC LIMIT 10
    ");
}

if (empty($mostthrown_array))
{
    while($mt = $vbulletin->db->fetch_array($mostthrown))
    {
        $mostthrown_array[] = $mt;
    }
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $vboptimise->set('mostthrown', serialize($mostthrown_array));
        devdebug('[tk] Egg Avatar: Cached most thrown.');
    }
}

// get the most popular eggs
$mostpopular_array = array();
if ($vbulletin->options['eggavatar_optimise'])
{
    $mp_cache = $vboptimise->fetch('mostpopular');

    if ($mp_cache) 
    { 
        $mostpopular_array = unserialize($mp_cache);
        devdebug('[tk] Egg Avatar: Fetched most popular eggs from cache.');
    }
    else
    {
        $mostpopular = $vbulletin->db->query_read("
            SELECT eggimage.image, eggimage.name, count(eggavatar.eggtype) as used 
            FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
            LEFT JOIN " . TABLE_PREFIX . "eggimage as eggimage ON eggimage.image = eggavatar.eggtype
            GROUP BY eggavatar.eggtype 
            ORDER BY used DESC LIMIT 5
        ");
    }
}
else
{
     $mostpopular = $vbulletin->db->query_read("
        SELECT eggimage.image, eggimage.name, count(eggavatar.eggtype) as used 
        FROM " . TABLE_PREFIX . "eggavatar as eggavatar 
        LEFT JOIN " . TABLE_PREFIX . "eggimage as eggimage ON eggimage.image = eggavatar.eggtype
        GROUP BY eggavatar.eggtype 
        ORDER BY used DESC LIMIT 5
    ");
}

if (empty($mostpopular_array))
{
    while($mp = $vbulletin->db->fetch_array($mostpopular))
    {
        $mostpopular_array[] = $mp;
    }
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $vboptimise->set('mostpopular', serialize($mostpopular_array));
        devdebug('[tk] Egg Avatar: Cached most popular eggs.');
    }
}

// load up the most eggged bits
$mostegged_bits = '';
$altclass = 1;
foreach($mostegged_array as $egged)
{
    $me_userid = $egged['userid'];
    $me_username = $egged['username'];
    $me_egged = $egged['egged'];
    eval('$mostegged_bits .= "' . fetch_template('eggav_mostegged_bit') . '";');
    $altclass = ($altclass == 1) ? 2 : 1;
}

// load up the most thrown bits
$mostthrown_bits = '';
$altclass = 1;
foreach($mostthrown_array as $thrown)
{
    $mt_userid = $thrown['userid'];
    $mt_username = $thrown['username'];
    $mt_thrown = $thrown['thrown'];
    eval('$mostthrown_bits .= "' . fetch_template('eggav_mostthrown_bit') . '";');
    $altclass = ($altclass == 1) ? 2 : 1;
}

// load up the most popular bits
$mostpopular_bits = '';
$altclass = 1;
foreach($mostpopular_array as $used)
{
    $mp_image = $vbulletin->options[eggavatar_eggpath] . $used['image'];
    $mp_name = $used['name'];
    $mp_used = $used['used'];
    eval('$mostpopular_bits .= "' . fetch_template('eggav_mostpopular_bit') . '";');
    $altclass = ($altclass == 1) ? 2 : 1;
}

eval('$eggav_output = "' . fetch_template('eggav_stats') . '";');   

?>